/*
 *	LCD interface example
 *	Uses routines from delay.c
 *	This code will interface to a standard LCD controller
 *	like the Hitachi HD44780. It uses it in 4 bit mode, with
 *	the hardware connected as follows (the standard 14 pin
 *	LCD connector is used):
 *
 *	PORTB bits 0-3 are connected to the LCD data bits 4-7 (high nibble)
 *	PORTA bit 4 is connected to the LCD RS input (register select)
 *	PORTA bit 5 is connected to the LCD EN bit (enable)
 *
 *	To use these routines, set up the port I/O (TRISA, TRISB) then
 *	call lcd_init(), then other routines as required.
 *
 */


#include <pic.h>
#include "main.h"
#include "delay.h"

static bit LCD_RS	@ ((unsigned)&PORTC*8+4);	// Register select
static bit LCD_EN	@ ((unsigned)&PORTC*8+5);	// Enable

#define	LCD_STROBE	((LCD_EN = 1),(LCD_EN=0))

/* write a byte to the LCD in 4 bit mode */

void
lcd_write(unsigned char c)
{
	PORTC &=0xF0;
	PORTC |= c >> 4;
	LCD_STROBE;
	PORTC &=0xF0;
	PORTC |= c&0x0F;
	LCD_STROBE;
	DelayUs(40);

}

/*
 * 	Clear and home the LCD
 */

void
lcd_clear(void)
{
	LCD_RS = 0;
	lcd_write(0x1);
	DelayMs(2);
}

/* write a string of chars to the LCD */

void
lcd_puts(const char * s)
{
	LCD_RS = 1;	// write characters
	while(*s)
	lcd_write(*s++);
}

/*
 * Go to the specified position
 */

void
lcd_goto(unsigned char pos)
{
	LCD_RS = 0;
	lcd_write(0x80+pos);
}

/* initialise the LCD - put into 4 bit mode */

void
lcd_init(void)
{
	TRISC&=0xD0;
	LCD_RS = 0;	// write control bytes
	DelayMs(15);	// power on delay
	PORTC &=0xF0;
	PORTC |= 0x3;	// attention!
	LCD_STROBE;
	DelayMs(5);
	LCD_STROBE;
	DelayUs(100);
	LCD_STROBE;
	DelayMs(5);
	PORTC &=0xF0;
	PORTC |= 0x2;	// set 4 bit mode
	LCD_STROBE;
	DelayUs(40);
	lcd_write(0x28);	// 4 bit mode, 1/16 duty, 5x8 font
	lcd_write(0x08);	// display off
	lcd_write(0x0F);	// display on, blink curson on
	lcd_write(0x06);	// entry mode
}

void lcd_putch(char c)
{
	char str[2];
	str[0]=c;
	str[1]=0;
	lcd_puts(str);
}


void ScrollMessage(unsigned char row,const char Message[])
{
 char TempS[30];
 unsigned int  MHead=0,Done=0,count;
 if(row >1) row=1;
 row=row*40;
 while(Done==0)
 {
  for(count=0;count<16;count++)
  {
	  TempS[count]=Message[MHead+count];
	  if(Message[MHead+count+1]==0) Done=1;
	 }
	 MHead++;
  lcd_goto(row);
  lcd_puts(TempS);
  DelayMs(60);
 }
}

